<?php namespace Visiosoft\StoreModule\User;

use function CoffeeScript\t;
use Visiosoft\StoreModule\User\Contract\UserInterface;
use Anomaly\Streams\Platform\Model\Store\StoreUserEntryModel;

class UserModel extends StoreUserEntryModel implements UserInterface
{
    public function findUser($user_id, $store_id)
    {
        return $this->where('store_id', $store_id)->where('user_id', $user_id)->get();
    }

    public function getUsers($store_id)
    {
        $userModel = new \Anomaly\UsersModule\User\UserModel();
        $users = $this->where('store_id', $store_id)->get();
        foreach ($users as $index => $user)
        {
            $users[$index] = $userModel->find($user->user_id);
        }
        return $users;
    }

    public function addUser($user_id, $store_id)
    {
        return $this->where('store_id', $store_id)->create([
            'user_id' => $user_id,
            'store_id' => $store_id,
        ]);
    }

    public function removeUser($user_id, $store_id)
    {
        return $this->where('store_id', $store_id)->where('user_id', $user_id)->delete();
    }

}
