<?php namespace Visiosoft\StoreModule\Store\Table\Actions;

use Anomaly\Streams\Platform\Ui\Table\Component\Action\ActionHandler;
use Visiosoft\StoreModule\Store\Table\StoreTableBuilder;

class Approve extends ActionHandler
{
    public function handle(StoreTableBuilder $builder, array $selected)
    {
        $model = $builder->getTableModel();
        $approved = false;

        foreach ($selected as $id) {
            if ($store = $model->newQuery()->find($id)) {
                $store->verify();
                $store->approve();
                $approved = true;
            }
        }

        if ($approved) {
            $this->messages->success(trans('streams::message.edit_success', [
                'name' => trans('module::field.status.name')
            ]));
        }
    }
}