<?php namespace Visiosoft\StoreModule\Store;

use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class StoreRepository extends EntryRepository implements StoreRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var StoreModel
     */
    protected $model;

    /**
     * Create a new StoreRepository instance.
     *
     * @param StoreModel $model
     */
    public function __construct(StoreModel $model)
    {
        $this->model = $model;
    }

    public function searchStores($param = null, $limit = null)
    {
        $query = $this->model;
        $query = $query->where('store_store.slug', '!=', "");
        $query = $query->leftJoin('store_store_translations', function ($join) {
            $join->on('store_store.id', '=', 'store_store_translations.entry_id');
            $join->where('store_store_translations.locale', '=', Request()->session()->get('_locale', setting_value('streams::default_locale')));
        });

        if (!empty($param['keyword'])) {
            $query = $query->where('description', 'LIKE', '%' . $param['keyword'] . '%')
            ->orWhere('name', 'like', '%' . $param['keyword'] . '%');
        }

        $query = $query->orderBy('store_store.created_at', 'desc');

        return $query->paginate(setting_value('streams::per_page'));
    }
}
