<?php namespace Visiosoft\StoreModule\Store\Command;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\StoreModule\Store\Contract\StoreInterface;

class ConfigureSubdomain
{
    use DispatchesJobs;

    protected $store;

    public function __construct(StoreInterface $store)
    {
        $this->store = $store;
    }

    public function handle()
    {
        set_time_limit(0);

        $useSubdomainRouting = setting_value('visiosoft.module.store::use_subdomain_routing');
        $apiToken = setting_value('visiosoft.module.store::api_token');
        $siteSlug = setting_value('visiosoft.module.store::site_slug');

        if ($useSubdomainRouting && $apiToken && $siteSlug) {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://openclassify.com/create-store-domain',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => array(
                    'api_key' => $apiToken,
                    'site_slug' => $siteSlug,
                    'store_url' => $this->store->slug . '.' . setting_value('streams::domain')
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
        }
    }
}
