<?php namespace Visiosoft\StoreModule\Doping;

use Visiosoft\StoreModule\Doping\Contract\DopingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class DopingRepository extends EntryRepository implements DopingRepositoryInterface
{
    protected $model;

    public function __construct(DopingModel $model)
    {
        $this->model = $model;
    }

    public function createNew($store_id, $doping_type_id, $price)
    {
        return $this->create([
            'store_id' => $store_id,
            'doping_type_id' => $doping_type_id,
            'price' => $price,
        ]);
    }

    public function getStoreDopings($store_id)
    {
        return $this->newQuery()->where('store_id', '=', $store_id)->get();
    }
}
