<?php namespace Visiosoft\StoreModule\User\Table;

use Anomaly\Streams\Platform\Entry\EntryModel;

class UserTableColumns
{
    public function handle(UserTableBuilder $builder)
    {

        $builder->setColumns([
            'store' => [
                'value' => function (EntryModel $entry) {
                    $store = $entry->getStore();
                    $url = route('visiosoft.module.store::admin.edit', ['id' => $store->getId()]);
                    return '<a href="' . $url . '">' . $store->getName() . '</a>';
                }
            ],
            'user' => [
                'value' => function (EntryModel $entry) {
                    $user = $entry->getUser();
                    $url = '/admin/users/edit/' . $user->getId();
                    return '<a href="' . $url . '">' . $user->name() . '(' . $user->getId() . ')</a>';
                }
            ],
        ]);
    }
}
