<?php namespace Visiosoft\StoreModule\Store\StoreRegister;

use Anomaly\UsersModule\User\Contract\UserInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Anomaly\UsersModule\User\Event\UserHasRegistered;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Anomaly\UsersModule\User\UserActivator;
use Illuminate\Contracts\Events\Dispatcher;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

/**
 * Class RegisterFormHandler
 *
 * @link   http://openclassify.com/
 * @author OpenClassify, Inc. <support@openclassify.com>
 * @author Visiosoft Inc <support@openclassify.com>
 */
class StoreRegisterFormHandler
{
    use DispatchesJobs;

    public function handle(
        Dispatcher $events,
        UserRepositoryInterface $users,
        StoreRegisterFormBuilder $builder,
        UserActivator $activator,
        Str $str,
        StoreRepositoryInterface $storeRepository
    )
    {
        if (!$builder->canSave()) {
            return;
        }

        $profile_parameters = array();

        /* Create Profile in Register */
        $domain = setting_value('streams::domain');
        $domain = str_replace('https://', '', $domain);
        $domain = str_replace('http://', '', $domain);
        $domain = str_replace('/', '', $domain);
        $domain = str_replace('www', '', $domain);

        $profile_parameters['gsm_phone'] = $builder->getPostValue('store_phone');
        if (!setting_value('visiosoft.module.advs::register_email_field')) {
            $builder->setFormValue('store_email', $builder->getPostValue('store_username') . "@" . $domain);
        }

        $fullName = $builder->getFormField('first_name')->getValue() . " " . $builder->getFormField('last_name')->getValue();

        // Get store fields
        $store = [
            'name' => $fullName,
            'summary' => trans('visiosoft.module.store::field.no_description_available'),
            'slug' => $str->slug($fullName) . Str::random(),
            'category' => $builder->getFormField('category')->getValue(),
            'country' => $builder->getFormField('country')->getValue(),
            'city' => $builder->getFormField('city')->getValue(),
            'address' => $builder->getFormField('address')->getValue(),
            'tax_number' => $builder->getFormField('tax_number')->getValue(),
            'tax_administration' => $builder->getFormField('tax_administration')->getValue(),
            'land_phone' => $builder->getFormField('land_phone')->getValue()
        ];

        $fields['first_name'] = $builder->getFormField('first_name')->getValue();
        $fields['last_name'] = $builder->getFormField('last_name')->getValue();
        $fields['display_name'] = $fullName;
        $fields['gsm_phone'] = $builder->getFormField('phone')->getValue();
        $fields['email'] = $builder->getFormField('email')->getValue();
        $fields['username'] = $builder->getFormField('username')->getValue();


        $register = $users->create($fields);
        $register->setAttribute('password', $builder->getFormField('password')->getValue());
        $users->save($register);

        /* @var UserInterface $user */
        $user = $register;

        $activator->start($user);
        $activator->force($user);

        // Create store
        $storeRepository->create(array_merge($store, [
            'user_id' => $user->getId()
        ]));

        $events->dispatch(new UserHasRegistered($user));
        Auth::login($user);

    }
}
