<?php namespace Visiosoft\StoreModule\Store\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class StoreTableBuilder extends TableBuilder
{

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [
        'search' => [
            'filter' => 'search',
            'fields' => [
                'name',
                'summary',
                'detailed_description',
            ],
        ],
        'category',
        'country',
    ];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'name',
        'land_phone',
        'owner_name' => [
            'value' => 'entry.user.name'
        ],
        'owner_phone' => [
            'value' => 'entry.user.gsm_phone'
        ],
        'status'
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'id' => 'desc'
        ],
    ];
}
