<?php namespace Visiosoft\StoreModule\Store;

use Anomaly\FilesModule\File\Command\GetFile;
use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Anomaly\Streams\Platform\Support\Collection;
use Anomaly\Streams\Platform\Support\Decorator;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreInterface;
use Anomaly\Streams\Platform\Model\Store\StoreStoreEntryModel;
use Visiosoft\StoreModule\User\UserModel;

class StoreModel extends StoreStoreEntryModel implements StoreInterface
{
    protected $appends = [
        'thumbnail',
    ];

    public function getThumbnailAttribute()
    {
        if ($this->file_id == null) {
            return $this->dispatch(new MakeImageInstance('visiosoft.theme.base::images/no-image.png', 'img'))->url();
        } else {
            return (new Decorator())->decorate($this->dispatch(new GetFile($this->file_id)))->make()->url();
        }
    }

    public function getName()
    {
        return $this->name;
    }

    public function approve()
    {
        return $this->update([
            'status' => 'approved'
        ]);
    }

    public function isApproved()
    {
        return $this->status === 'approved';
    }

    public function getOwner()
    {
        return $this->user;
    }

    public function getStoreUsers()
    {
        $users_store = $this->hasMany(UserModel::class, 'store_id')->get();
        $users = new Collection();
        foreach ($users_store as $user) {
            $users->add($user->getUser());
        }
        $users->add($this->user);

        return $users;
    }

    public function getCity()
    {
        return app(CityRepositoryInterface::class)->find($this->city);
    }

    public function getDistrict()
    {
    	return app(DistrictRepositoryInterface::class)->find($this->district_id);
    }

    public function verify()
    {
        $this->update(['verified' => true]);
    }

    public function refute()
    {
        $this->update(['verified' => false]);
    }

    public function storeDetailURL()
    {
        return route('store::view', [$this->slug]);
    }

    public function scopeWithTrans($query)
    {
        return $query
            ->leftJoin('store_store_translations as store_trans', function ($join) {
                $join->on('store_store.id', '=', 'store_trans.entry_id');
                $join->whereIn('locale', [config('app.locale'), setting_value('streams::default_locale'), 'en']);
            });
    }
}
