<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleStoreCreateDopingsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'dopings',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */

    protected $fields = [
        'doping_type' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\StoreModule\DopingType\DopingTypeModel::class,
            ]
        ],
        'finish_at' => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "mode" => "date",
            ]
        ],
    ];

    protected $assignments = [
        'store' => [
            'required' => true,
        ],
        'doping_type' => [
            'required' => true,
        ],
        'price' => [
            'required' => true,
        ],
        'finish_at',
        'status' => [
            'required' => true,
        ],
    ];

}
