<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\StoreModule\Store\StoreModel;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\LocationModule\City\CityModel;

class VisiosoftModuleStoreCreateStoreFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'slug' => [
            'type' => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'name',
                'type' => '_'
            ],
        ],
        'file' => [
            'type' => 'visiosoft.field_type.singlefile',
            'config' => [
                'folders' => ["images"],
                'mode' => 'upload',
            ]
        ],
        'description' => 'anomaly.field_type.text',
        'land_phone' => 'anomaly.field_type.text',
        'store' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => StoreModel::class,
            ]
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class
            ]
        ],
        'category' => [
            'type' => 'anomaly.field_type.select',
            'config' => [
                'handler' => 'Visiosoft\StoreModule\Store\Form\CategoriesOptions@handle'
            ],
        ],
        'country' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => CountryModel::class
            ]
        ],
        'city' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => CityModel::class
            ]
        ],
        'address' => 'anomaly.field_type.text',
        'email' => 'anomaly.field_type.email',
        'web_site' => 'anomaly.field_type.text',
        'gold_supplier' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => 0,
            ]
        ],
        'facebook' => 'anomaly.field_type.text',
        'instagram' => 'anomaly.field_type.text',
        'twitter' => 'anomaly.field_type.text',
        'store_banner' => [
            'type' => 'anomaly.field_type.file',
            'config' => [
                'folders' => ['store_banner_folder'],
                'mode' => 'select',
            ]
        ]
    ];

}
