<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleStoreCreateDopingTypesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = false;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'doping_types',
        'title_column' => 'name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $fields = [
        'duration' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 15
            ],
        ],
    ];
    protected $assignments = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'slug' => [
            'unique' => true,
            'required' => true,
        ],
        'price' => [
            'required' => true,
        ],
        'duration' => [
            'required' => true,
        ],
    ];

}
