<?php namespace Visiosoft\StoreModule\Store\Form;

use Anomaly\SelectFieldType\SelectFieldType;
use Visiosoft\StoreModule\Category\Contract\CategoryRepositoryInterface;

class CategoriesOptions
{
    private $categoryRepository;

    public function __construct(CategoryRepositoryInterface $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    public function handle(SelectFieldType $fieldType)
    {
        $categories = $this->categoryRepository->newQuery()->get()->pluck('name', 'id')->all();
        $fieldType->setOptions($categories);
    }
}
