<?php namespace Visiosoft\StoreModule\Doping\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class DopingFormBuilder extends FormBuilder
{
    protected $fields = [
        'store' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'title_name' => 'name',
                'related' => \Visiosoft\StoreModule\Store\StoreModel::class,
            ]
        ],
        'doping_type' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\StoreModule\DopingType\DopingTypeModel::class,
            ]
        ],
        'price' => [
            'required' => true,
        ],
        'finish_at' => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "mode" => "date",
            ]
        ],
        'status' => [
            'required' => true,
        ],
    ];
    protected $buttons = [
        'cancel',
    ];
}
