<?php namespace Visiosoft\StoreModule\Store;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;

class StoreCriteria extends EntryCriteria
{
    public function getStore()
    {
        $StoreModel = new StoreModel();
        $storeRepository = new StoreRepository($StoreModel);
        return $storeRepository->findBy('user_id', Auth::id());
    }

    public function storeAds($userId)
    {
        $advModel = new AdvModel();
        $latest_advs = AdvModel::query()
            ->whereDate('finish_at', '>=', date("Y-m-d H:i:s"))
            ->where('status', '=', 'approved')
            ->where('slug', '!=', '')
            ->where('advs_advs.created_by_id', $userId)
            ->limit(3)
            ->get();

        $ads = $advModel->getLocationNames($latest_advs);
        foreach ($ads as $index => $ad) {
            $ads[$index]->detail_url = $advModel->getAdvDetailLinkByModel($ad, 'list');
            $ads[$index] = $advModel->AddAdsDefaultCoverImage($ad);
        }
        return $ads;
    }
}
