<?php namespace Visiosoft\StoreModule\Store\Listeners;

use Visiosoft\CartsModule\Cart\Event\CartRemove;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class RemoveStoreCart
{
    private $store;

    public function __construct(StoreRepositoryInterface $storeRepository)
    {
        $this->store = $storeRepository;
    }

    public function handle(CartRemove $event)
    {
        $item = $event->getItem();
        if ($item->entry_type == "Visiosoft\StoreModule\Store\StoreModel") {
            $this->store->find($item->entry_id)->forceDelete();
        }
    }
}
