<?php namespace Visiosoft\StoreModule\Store\Listeners;

use Visiosoft\OrdersModule\Events\StoreOrderApproved;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class ApproveStore
{
    private $storeRepository;

    public function __construct(StoreRepositoryInterface $storeRepository)
    {
        $this->storeRepository = $storeRepository;
    }

    public function handle(StoreOrderApproved $event)
    {
        $store = $this->storeRepository->find($event->getOrderDetail()->item_id);
        $store->approve();
    }
}