<?php namespace Visiosoft\StoreModule\Seed;

use Anomaly\BlocksModule\Area\Contract\AreaRepositoryInterface;
use Anomaly\BlocksModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Database\Seeder;
use Anomaly\BlocksModule\Block\Contract\BlockRepositoryInterface;

class RegisterInstructionSeeder extends Seeder
{
    private $areaRepository;
    private $blocksTypeRepository;
    private $fieldRepository;
    private $streamRepository;
    private $blockRepository;

    public function __construct(
        AreaRepositoryInterface $areaRepository,
        TypeRepositoryInterface $blocksTypeRepository,
        FieldRepositoryInterface $fieldRepository,
        StreamRepositoryInterface $streamRepository,
        BlockRepositoryInterface $blockRepository
    ) {
        $this->areaRepository = $areaRepository;
        $this->blocksTypeRepository = $blocksTypeRepository;
        $this->fieldRepository = $fieldRepository;
        $this->streamRepository = $streamRepository;
        $this->blockRepository = $blockRepository;
    }

    public function run()
    {
        // Create block area
        if ($registerInstructionsArea = $this->areaRepository->findBySlug('store-register-instructions')) {
            $registerInstructionsArea->delete();
        }
        $registerInstructionsArea = $this->areaRepository->create([
            'name' => trans('visiosoft.module.store::field.store_register_instructions'),
            'slug' => 'store-register-instructions',
        ]);

        // Check require
        $blockType = $this->blocksTypeRepository->findBySlug('list');
        $listBlock = $this->streamRepository->findBySlugAndNamespace('list_blocks', 'blocks');
        $descField = $this->fieldRepository->findBySlugAndNamespace('instruction_description', 'blocks');
        $listField = $this->fieldRepository->findBySlugAndNamespace('instruction_list', 'blocks');

        if ($blockType && $listBlock && $descField && $listField) {
            // Add default instructions
            $blockFieldId = $this->fieldRepository->findBySlugAndNamespace('blocks', 'blocks')->getId();
            $block = $this->blockRepository->create([
                'title' => trans('visiosoft.module.store::field.corporate_registration_header'),
                'field' => $blockFieldId,
                'extension' => 'anomaly.extension.list_block',
                'display_title' => false,
            ]);
            $blockInfo = app('Anomaly\Streams\Platform\Model\Blocks\BlocksListBlocksEntryModel')->newQuery()->create([
                'instruction_description' => trans('visiosoft.module.store::field.corporate_registration_body'),
                'instruction_list' => [
                    trans('visiosoft.module.store::field.corporate_registration_list_1'),
                    trans('visiosoft.module.store::field.corporate_registration_list_2'),
                ]
            ]);
            $block->update([
                'area_id' => $registerInstructionsArea->getId(),
                'area_type' => get_class($registerInstructionsArea),
                'entry_id' => $blockInfo->id,
                'entry_type' => get_class($blockInfo),
            ]);
        }
    }
}