<?php namespace Visiosoft\StoreModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\StoreModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\StoreModule\Price\Form\PriceFormBuilder;
use Visiosoft\StoreModule\Price\Table\PriceTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class PricesController extends AdminController
{
    public function index(PriceTableBuilder $table)
    {
        $table->setColumns([
            'id' => 'entry.id',
            'category' => [
                'value' => function (EntryInterface $entry, CategoryRepositoryInterface $categoryRepository) {
                    $cat = $categoryRepository->find($entry->category);
                    return $cat ? $cat->name : '';
                },
            ],
            'price',
        ]);

        return $table->render();
    }

    public function create(PriceFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(PriceFormBuilder $form, $id)
    {
        return $form->render($id);
    }
}
