<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleStoreCreateStatusFields extends Migration
{
    /**
     * Don't delete stream on rollback
     * because this isn't creating the
     * stream only referencing it.
     */
    protected $delete = false;

    /**
     * Any additional information will
     * be updated. Slug helps find
     * the stream to work with for
     * assignments that follow.
     */
    protected $stream = [
        'slug' => 'store',
    ];

    /**
     * This field will be added.
     */
    protected $fields = [
        "status" => [
            "type"   => "anomaly.field_type.select",
            "config" => [
                "options"       => [
                    'approved' => 'visiosoft.module.store::field.approved',
                    'pending' => 'visiosoft.module.store::field.pending'
                ],
                "default_value" => 'pending',
                "mode"          => "dropdown",
            ]
        ],
    ];

    /**
     * These assignments will be
     * created for the stream above.
     */
    protected $assignments = [
        'status',
    ];
}
