<?php namespace Visiosoft\StoreModule\Store\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;

class StoreTableButtons
{
    public function handle(StoreTableBuilder $builder)
    {
        $builder->setButtons([
            'verify' => [
                'text' => function (EntryInterface $entry) {
                    $text = $entry->verified ? 'refute' : 'verify';
                    return trans('visiosoft.module.store::button.' . $text);

                },
                'icon' => function (EntryInterface $entry) {
                    return $entry->verified ? "fa fa-times-circle" : "fa fa-check-circle";
                },
                'href' => function (EntryInterface $entry) {
                    $action = $entry->verified ? 'refute' : 'verify';
                    return "/admin/store/$action/{entry.id}";
                },
                'type' => function (EntryInterface $entry) {
                    return $entry->verified ? "danger" : "success";
                },
            ],
            'edit',
        ]);
    }

}
