<?php namespace Visiosoft\StoreModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\Store\Form\StoreFormBuilder;
use Visiosoft\StoreModule\Store\StoreModel;

class StoreController extends PublicController
{
    private $model;
    private $advModel;
    private $storeUserRepository;
    private $advRepository;
    private $storeRepository;
    private $categoryRepository;

    public function __construct(
        StoreModel $storeModel,
        AdvModel $advModel,
        \Visiosoft\StoreModule\User\Contract\UserRepositoryInterface $storeUserRepository,
        AdvRepositoryInterface $advRepository,
        StoreRepositoryInterface $storeRepository,
        CategoryRepositoryInterface $categoryRepository
    )
    {
        parent::__construct();
        $this->model = $storeModel;
        $this->advModel = $advModel;
        $this->storeUserRepository = $storeUserRepository;
        $this->advRepository = $advRepository;
        $this->storeRepository = $storeRepository;
        $this->categoryRepository = $categoryRepository;
    }

    public function index($slug, Request $request)
    {
        $store = $this->storeRepository->findBy('slug', $slug);
        if ($store) {
            $users = $this->storeRepository->getStoreUsers($store);
            $ads = array();
            foreach ($users as $user) {
                $userAds = $this->advRepository->newQuery()->where('advs_advs.created_by_id', $user->id)->get();
                foreach ($userAds as $userAd) {
                    $ads[] = $userAd;
                }
            }

            $advs = $this->advRepository->addAttributes($ads);
            foreach ($advs as $index => $ad) {
                $advs[$index]->detail_url = $this->advModel->getAdvDetailLinkByModel($ad, 'list');
                $advs[$index] = $this->advModel->AddAdsDefaultCoverImage($ad);
            }

            $cat = null;
            $mainCats = $this->categoryRepository->mainCats();

            $compact = compact('advs', 'mainCats', 'request', 'ownerId', 'store');

            $viewType = $request->cookie('viewType');

            if (isset($viewType) and $viewType == 'table') {
                return $this->view->make('visiosoft.module.advs::list/table', $compact);
            } elseif (isset($viewType) and $viewType == 'map') {
                return $this->view->make('visiosoft.module.advs::list/map', $compact);
            }

            return $this->view->make('visiosoft.module.advs::list/list', $compact);
        }
        abort(404);
    }


    public function edit(Request $request, StoreFormBuilder $form, $slug, $id)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->storeRepository->find($id);
        if ($store and $store->user_id == Auth::id()) {
            if ($request->action == "save") {
                $form->skipField('user');
                if ($form->hasFormErrors()) {
                    return back();
                }
                $form->render($id);
                return redirect(route('store::view', [$store->slug]));
            }
            return $this->view->make('visiosoft.module.store::edit', compact('store'));
        }
        abort(403);
    }


    public function create(Request $request, StoreFormBuilder $form)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        if ($request->action == "save") {
            $error = $form->build()->validate()->getFormErrors()->getMessages();
            if (!empty($error)) {
                return back();
            }
            $form->render();
            return redirect(route('store::view', [$request->slug]));
        }
        $mainCats = $this->categoryRepository->mainCats();
        return $this->view->make('visiosoft.module.store::create', compact('mainCats'));
    }

    public function addUser(Request $request, UserRepositoryInterface $userRepository, $slug)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->storeRepository->findBy('slug', $slug);
        $users =  $this->storeUserRepository->getUsers($store->id);
        if ($store and $store->user_id == Auth::id()) {
            if ($request->action == "save") {
                $user = $userRepository->findByEmail($request->user);
                if($user != null) {
                    $findUser = $this->storeUserRepository->findUser($user->id, $store->id);
                    if($store->user_id != $user->id and count($findUser) == 0) {
                        $this->storeUserRepository->addUser($user->id, $store->id);
                        return redirect('s/'.$store->slug.'/add-user')->withSuccess([trans('visiosoft.module.store::message.user_added')]);
                    } else {
                        return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.already_defined_user')]);
                    }
                } else {
                    return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.user_not_found')]);
                }
            }
            return $this->view->make('visiosoft.module.store::add-user', compact('store', 'users'));
        }
        abort(403);
    }

    public function removeUser($slug, $userId)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->storeRepository->findBy('slug', $slug);
        if ($store and $store->user_id == Auth::id()) {
            $find_user = $this->storeUserRepository->findUser($userId, $store->id);
            if($store->user_id != $userId and count($find_user) != 0)
            {
                $this->storeUserRepository->removeUser($userId, $store->id);
                return redirect('s/'.$store->slug.'/add-user')->withSuccess([trans('visiosoft.module.store::message.user_deleted')]);
            } else {
                return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.user_not_found')]);
            }
        }
        abort(403);
    }

    public function listStores(Request $request)
    {
        $params = $request->toArray();

        $stores = $this->storeRepository->searchStores($params);

        $cats = $this->categoryRepository->mainCats();

        $compact = compact('stores', 'request', 'cats');

        Cookie::queue(Cookie::make('last_search', $request->getRequestUri(), 84000));

        return $this->view->make('visiosoft.module.store::list/list', $compact);
    }
}
