<?php


use Anomaly\Streams\Platform\Model\Location\LocationCitiesEntryModel;
use Anomaly\Streams\Platform\Model\Location\LocationDistrictsEntryModel;
use Visiosoft\LocationModule\Country\CountryModel;

return [
    'auto_approve' => [
        'type'   => 'anomaly.field_type.boolean',
        'bind'   => 'store.auto_approve',
        'env'      => 'STORE_AUTO_APPROVE',
        'config' => [
            'default_value' => true,
        ],
    ],
    'store_price' => [
        'type'     => 'anomaly.field_type.integer',
        'bind'   => 'store.store_price',
        'env'      => 'STORE_PRICE',
        'required' => true,
        'config'   => [
            'default_value' => 10,
        ],
    ],
    'store_currency' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'handler' => 'currencies',
        ],
    ],
];
