<?php namespace Visiosoft\StoreModule\Store;

use Illuminate\Support\Carbon;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\StoreModule\User\Contract\UserRepositoryInterface;

class StoreRepository extends EntryRepository implements StoreRepositoryInterface
{

    protected $model;
    protected $categoryRepository;
    protected $storeUserRepository;

    /**
     * Create a new StoreRepository instance.
     *
     * @param StoreModel $model
     * @param CategoryRepositoryInterface $categoryRepository
     * @param UserRepositoryInterface $storeUserRepository
     */
    public function __construct(
        StoreModel $model,
        CategoryRepositoryInterface $categoryRepository,
        UserRepositoryInterface $storeUserRepository
    )
    {
        $this->model = $model;
        $this->categoryRepository = $categoryRepository;
        $this->storeUserRepository = $storeUserRepository;
    }

    public function searchStores($param = null, $limit = null, $get_query = false)
    {
        $query = $this->model;
        $query = $query->where('store_store.slug', '!=', "")->where('store_store.status', 'approved');
        $query = $query->leftJoin('store_store_translations', function ($join) {
            $join->on('store_store.id', '=', 'store_store_translations.entry_id');
            $join->where('store_store_translations.locale', '=', Request()->session()->get('_locale', setting_value('streams::default_locale')));
        });

        if (!empty($param['keyword'])) {
            $query = $query->where('summary', 'LIKE', '%' . $param['keyword'] . '%')
                ->orWhere('name', 'like', '%' . $param['keyword'] . '%');
        }
        if (!empty($param['country'])) {
            $query = $query->where('country_id', $param['country']);
        }
        if (isset($param['city']) and (!empty($param['city']))) {
            $citiesIds = explode(',', $param['city'][0]);
            $query = $query->whereIn('city', $citiesIds);
        }
        if (!empty($param['cat'])) {
            $query = $query->where('category', $param['cat']);
        }
        if (!empty($param['gold'])) {
            $query = $query->where('gold', 1);
        }
        if (!empty($param['date'])) {
            if ($param['date'] === 1) {
                $query = $query->where('store_store.created_at', '>=', Carbon::now()->subYears(1));
            } elseif ($param['date'] === 2) {
                $query = $query->where('store_store.created_at', '>=', Carbon::now()->subYears(2));
            } elseif ($param['date'] === 3) {
                $query = $query->where('store_store.created_at', '>=', Carbon::now()->subYears(3));
            }
        }

        if ($get_query) {
            return $query;
        }

        $query = $query->orderBy('store_store.created_at', 'desc');

        return $query->paginate(setting_value('streams::per_page'));
    }

    public function findBySlug($slug)
    {
        return $this->newQuery()->where('slug', $slug)->first();
    }

    public function findByUser($userId)
    {
        return $this->newQuery()->where('user_id', $userId)->first();
    }
}
