<?php namespace Visiosoft\StoreModule\Doping\Table;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Ui\Table\Table;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class DopingTableBuilder extends TableBuilder
{

    protected $columns = [
        'store' => [
            'wrapper' => '{value.name}',
            'value' => [
                'name' => 'entry.store.getName()'
            ],
        ],
        'doping_type','status',
        'finish_at' => 'entry.finish_at',
    ];

    protected $buttons;

    protected $actions = [
        'delete'
    ];

    public function __construct(Table $table)
    {
        parent::__construct($table);
        $this->buttons = $this->btn();
    }

    private function btn()
    {
        return [
            'approve' => [
                'type' => 'success',
                'href' => 'admin/store/dopings/approve/{entry.id}',
                'disabled' => function (EntryInterface $entry) {
                    return $entry->status === 'approved';
                },
            ],
            'edit',
        ];
    }
}
