<?php namespace Visiosoft\StoreModule\Store;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryObserver;
use Visiosoft\StoreModule\Events\StoreWasCreated;

class StoreObserver extends EntryObserver
{
    public function creating(EntryInterface $entry)
    {
        if (!$entry->status) {
            if (setting_value('visiosoft.module.store::enable_store_prices')) {
                $entry->setAttribute('status', 'pending');
            } else {
                $entry->setAttribute('status', 'approved');
            }
        }
        event(new StoreWasCreated($entry));
        parent::creating($entry);
    }
}
