<?php namespace Visiosoft\StoreModule\Http\Controller\Admin;

use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\Store\StoreExports;
use Visiosoft\StoreModule\User\Form\UserFormBuilder;
use Visiosoft\StoreModule\User\Table\UserTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class UserController extends AdminController
{
    public function index(UserTableBuilder $table)
    {
        return $table->render();
    }

    public function create(UserFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(UserFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function export(StoreRepositoryInterface $store)
    {
        return Excel::download(new StoreExports, 'usersStore.xlsx');
    }
}
