<?php namespace Visiosoft\StoreModule\User;

use Visiosoft\StoreModule\User\Contract\UserRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class UserRepository extends EntryRepository implements UserRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var UserModel
     */
    protected $model;
    protected $userRepository;

    /**
     * Create a new UserRepository instance.
     *
     * @param UserModel $model
     * @param \Anomaly\UsersModule\User\Contract\UserRepositoryInterface $userRepository
     */
    public function __construct(UserModel $model, \Anomaly\UsersModule\User\Contract\UserRepositoryInterface $userRepository)
    {
        $this->model = $model;
        $this->userRepository = $userRepository;
    }

    public function getUsers($storeId)
    {
        $users = $this->model->newQuery()->where('store_id', $storeId)->get();
        foreach ($users as $index => $user)
        {
            $users[$index] = $this->userRepository->find($user->user_id);
        }
        return $users;
    }

    public function findUser($userId, $storeId)
    {
        return $this->model->newQuery()->where('store_id', $storeId)->where('user_id', $userId)->get();
    }

    public function addUser($userId, $storeId)
    {
        return $this->model->newQuery()->create([
            'user_id' => $userId,
            'store_id' => $storeId,
        ]);
    }

    public function removeUser($userId, $storeId)
    {
        return $this->model->newQuery()->where('store_id', $storeId)->where('user_id', $userId)->delete();
    }
}
