<?php namespace Visiosoft\StoreModule\Doping;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class DopingCriteria extends EntryCriteria
{
    public function getStoresByType($type_slug)
    {
        $store_ids = $this->getQueryModel()
            ->newQuery()
            ->where('status', 'approved')
            ->whereDate('finish_at', '>=', date("Y-m-d"))
            ->limit(setting_value('visiosoft.module.store::homeShowcaseLimit', 5))
            ->get()->pluck('store_id')->all();

        $storeRepository = app(StoreRepositoryInterface::class);

        return $storeRepository->getApprovedStoresByIds($store_ids);
    }
}
