<?php namespace Visiosoft\StoreModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Store\StorePricesEntryModel;
use Maatwebsite\Excel\ExcelServiceProvider;
use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\OrdersModule\Events\StoreOrderApproved;
use Visiosoft\StoreModule\Store\Listeners\ApproveStore;
use Visiosoft\StoreModule\Price\Contract\PriceRepositoryInterface;
use Visiosoft\StoreModule\Price\PriceModel;
use Visiosoft\StoreModule\Price\PriceRepository;
use Visiosoft\StoreModule\Store\StoreRegister\StoreRegisterFormBuilder;
use Visiosoft\StoreModule\User\Contract\UserRepositoryInterface;
use Visiosoft\StoreModule\User\UserRepository;
use Anomaly\Streams\Platform\Model\Store\StoreUserEntryModel;
use Visiosoft\StoreModule\User\UserModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\Store\StoreRepository;
use Anomaly\Streams\Platform\Model\Store\StoreStoreEntryModel;
use Visiosoft\StoreModule\Store\StoreModel;

class StoreModuleServiceProvider extends AddonServiceProvider
{
    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
        StoreModulePlugin::class
    ];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/store/user' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@index',
        'admin/store/export' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@export',
        'admin/store/user/export' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@export',
        'admin/store/user/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@create',
        'admin/store/user/edit/{id}' => 'Visiosoft\StoreModule\Http\Controller\Admin\UserController@edit',
        'admin/store' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@index',
        'admin/store/create' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@create',
        'admin/store/edit/{id}' => [
            'as' => 'visiosoft.module.store::admin.edit',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\Admin\StoreController@edit',
        ],
        'store/list' => [
            'as' => 'store::list',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@listStores'
        ],
        's/{slug}/edit/{id}' => [
            'as' => 'store::edit',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@edit',
        ],
        's/{slug}/save/{id}' => [
            'as' => 'store::edit_save',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@store',
        ],
        'store/create' => [
            'middleware' => 'auth',
            'as' => 'store::create',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@create',
        ],
        'store/{slug}' => [
            'as' => 'store::view',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@index',
        ],
        'store/{slug}/detail' => [
            'as' => 'store::detail',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@storeDetail',
        ],
        's/{slug}/add-user' => [
            'as' => 'store::add-user',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@addUser',
        ],
        's/{slug}/remove-user/{id}' => [
            'as' => 'store::remove-user',
            'uses' => 'Visiosoft\StoreModule\Http\Controller\StoreController@removeUser',
        ],
    ];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        StoreOrderApproved::class => [
            ApproveStore::class
        ]
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        'Excel' => Excel::class,
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        StoreUserEntryModel::class => UserModel::class,
        StoreStoreEntryModel::class => StoreModel::class,
        StorePricesEntryModel::class => PriceModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        UserRepositoryInterface::class => UserRepository::class,
        StoreRepositoryInterface::class => StoreRepository::class,
        PriceRepositoryInterface::class => PriceRepository::class,
        'store-register' => StoreRegisterFormBuilder::class
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        ExcelServiceProvider::class,
    ];
}
