<?php namespace Visiosoft\StoreModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Sunra\PhpSimple\HtmlDomParser;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\StoreModule\Ad\AdModel;
use Visiosoft\StoreModule\Store\Form\StoreFormBuilder;
use Visiosoft\StoreModule\Store\StoreModel;
use Visiosoft\StoreModule\User\Form\UserFormBuilder;
use Visiosoft\StoreModule\User\UserModel;

class StoreController extends PublicController
{
    private $model;
    private $advModel;
    private $StoreAdModel;
    private $StoreUserModel;

    public function __construct(StoreModel $storeModel, AdvModel $advModel, AdModel $adModel, UserModel $StoreUserModel)
    {
        parent::__construct();
        $this->model = $storeModel;
        $this->advModel = $advModel;
        $this->StoreAdModel = $adModel;
        $this->StoreUserModel = $StoreUserModel;
    }

    public function index($slug, AdvRepositoryInterface $advRepository, Request $request)
    {
        $store = $this->model->getStoreDetail($slug);
        if ($store) {
            $advmodel = new AdvModel();

            $query = $this->StoreAdModel->where('store_ads.store_id', $store->id);

            $query = $query->leftJoin('advs_advs', function ($join) {
                $join->on('store_ads.ad_id', '=', 'advs_advs.id');
                $join->where('advs_advs.slug', '!=', "");
                $join->where('advs_advs.status', 'approved');
                $join->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'));
            });
            $query = $query->where('advs_advs.status', 'approved');

            $query = $query
                ->leftJoin('advs_advs_translations', 'store_ads.ad_id', '=', 'advs_advs_translations.entry_id')
                ->where('locale', config('app.locale'));

            $advs = $query->select('advs_advs.*', 'advs_advs_translations.name as name')
                ->get();


//            $query = $this->advModel
//                ->where('advs_advs.slug', '!=', "")
//                ->where('advs_advs.status', 'approved')
//                ->where('advs_advs.finish_at', '>', date('Y-m-d H:i:s'));
//
//            $query = $query->Join('store_ads', function ($join) {
//                $join->on('advs_advs.id', '=', 'store_ads.ad_id');
//            });
//
//            $advs = $query->select('advs_advs.*')->get();


            $advs = $advRepository->addAttributes($advs);
            foreach ($advs as $index => $ad) {
                $advs[$index]->detail_url = $advmodel->getAdvDetailLinkByModel($ad, 'list');
                $advs[$index] = $advmodel->AddAdsDefaultCoverImage($ad);
            }

            $type = 'list';

            $compact = compact('advs', 'request', 'type', 'store');

            return $this->view->make('visiosoft.module.store::list', $compact);
        }
        abort(404);
    }


    public function edit(Request $request, StoreFormBuilder $form, $slug, $id)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->model->getStoreDetail($slug);
        if ($store and $store->user_id == Auth::id()) {
            if ($request->action == "save") {
                $form->skipField('user');
                $form->render($id);
                return redirect('/s/' . $request->slug);
            } else {
                $nameField = HTMLDomParser::str_get_html($form->render($id)->getContent());
                $nameField = $nameField->find('.name', 0);
                if ($nameField !== null) {
                    $nameField = $nameField->innertext();
                } else {
                    $nameField = "";
                }
            }
            return $this->view->make('visiosoft.module.store::edit', compact('store', 'nameField'));
        }
        abort(403);
    }


    public function create(Request $request, StoreFormBuilder $form)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        if ($request->action == "save") {
            $error = $form->build()->validate()->getFormErrors()->getMessages();
            if (!empty($error)) {
                return $this->redirect->back();
            }
            $form->render();
            return redirect('/s/' . $request->slug);
        } else {
            $nameField = HTMLDomParser::str_get_html($form->render()->getContent());
            $nameField = $nameField->find('.name', 0);
            if ($nameField !== null) {
                $nameField = $nameField->innertext();
            } else {
                $nameField = "";
            }
        }
        return $this->view->make('visiosoft.module.store::create', compact('store','nameField'));
    }

    public function addUser(Request $request, UserRepositoryInterface $userRepository, $slug)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->model->getStoreDetail($slug);
        $users =  $this->StoreUserModel->getUsers($store->id);
        if ($store and $store->user_id == Auth::id()) {
            if ($request->action == "save") {
                $user = $userRepository->findByEmail($request->user);
                if($user != null)
                {
                    $find_user = $this->StoreUserModel->findUser($user->id, $store->id);
                    if($store->user_id != $user->id and count($find_user) == 0)
                    {
                        $this->StoreUserModel->addUser($user->id, $store->id);
                        return redirect('s/'.$store->slug.'/add-user')->withSuccess([trans('visiosoft.module.store::message.user_added')]);
                    } else {
                        return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.already_defined_user')]);
                    }
                } else {
                    return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.user_not_found')]);
                }
            }
            return $this->view->make('visiosoft.module.store::add-user', compact('store', 'users'));
        }
        abort(403);
    }

    public function removeUser($slug, $user_id)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->model->getStoreDetail($slug);
        if ($store and $store->user_id == Auth::id()) {
                    $find_user = $this->StoreUserModel->findUser($user_id, $store->id);
                    if($store->user_id != $user_id and count($find_user) != 0)
                    {
                        $this->StoreUserModel->removeUser($user_id, $store->id);
                        return redirect('s/'.$store->slug.'/add-user')->withSuccess([trans('visiosoft.module.store::message.user_deleted')]);
                    } else {
                        return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.user_not_found')]);
                    }
        }
        abort(403);
    }
}
