<?php namespace Visiosoft\StoreModule\Ad;

use Illuminate\Support\Facades\Auth;
use Visiosoft\StoreModule\Ad\Contract\AdInterface;
use Anomaly\Streams\Platform\Model\Store\StoreAdsEntryModel;

class AdModel extends StoreAdsEntryModel implements AdInterface
{

    public function createStoreAdLoggedInUser($store_id, $ad_id)
    {
        $this->create([
            'store_id' => $store_id,
            'ad_id' => $ad_id,
            'user_id' => Auth::id(),
        ]);
    }
}
