getCountries();

const countryInit = () => {
    const selectedCountry = typeof country !== 'undefined' ? country : default_country
    if (parseInt(selectedCountry)) {
        $('select[name="country"]').val(selectedCountry);
        getCities(parseInt(selectedCountry)).then(function () {
            if (typeof city !== 'undefined') {
                $('select[name="city"]').val(city);
            }
        });
    }
}

function getCities(country) {
    const selectCityInput = $('select[name=city]')
    selectCityInput.prop('disabled', true)
    return crud(`id=${country}`, '/ajax/getCities', 'POST', function (callback) {
        cities = callback;
        $('select[name="city"]').html("<option value=''>" + pick_option + "</option>");
        $.each(cities, function (index, value) {
            $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
        selectCityInput.prop('disabled', false)
    })
}

$(document).on('change', 'select[name="country"]', function () {
    getCities($(this).val());
});

function crud(params, url, type, callback) {
    return $.ajax({
        type: type,
        data: params,
        async: true,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}

function getCountries() {
    crud('', '/ajax/getCountry', 'GET', function (callback) {
        $('select[name="country"]').html("<option>" + pick_option + "</option>");
        $.each(callback, function (index, value) {
            $('select[name="country"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
        countryInit();
    })
}
