<?php

return [
    'auto_approve' => [
        'type' => 'anomaly.field_type.boolean',
        'bind' => 'store.auto_approve',
        'env' => 'STORE_AUTO_APPROVE',
        'config' => [
            'default_value' => true,
        ],
    ],
    'store_price' => [
        'type' => 'anomaly.field_type.integer',
        'bind' => 'store.store_price',
        'env' => 'STORE_PRICE',
        'required' => true,
        'config' => [
            'default_value' => 10,
        ],
    ],
    'store_currency' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'handler' => 'currencies',
        ],
    ],
    'homeShowcaseLimit' => [
        'type' => 'anomaly.field_type.integer',
        'config' => [
            'default_value' => 5,
        ],
    ],
    'enable_store_prices' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
            "mode" => "checkbox",
        ],
    ],
    'default_store_price' => [
        'type' => 'anomaly.field_type.decimal',
        'config' => [
            'default_value' => 10,
        ],
    ],
    'combineStore' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
            "mode" => "radio",
        ],
    ],
    'show_website' => 'anomaly.field_type.boolean',
    'show_country' => 'anomaly.field_type.boolean',
    'view_type' => [
        'type' => 'anomaly.field_type.select',
        'config' => [
            'options' => [
                'gallery' => 'visiosoft.module.store::setting.gallery_view',
                'list' => 'visiosoft.module.store::setting.list_view'
            ]
        ]
    ],
    'store_detail_page' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    'show_detail_page' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => false,
        ]
    ],
    "default_detail_page" => [
        "type" => 'anomaly.field_type.editor',
        "instructions" => "{{land_phone}}   {{gsm_phone}}         
                            {{slug}}           
                            {{summary}} 
                            {{detailed_description}}           
                            {{address}}        
                            {{email}}           
                            {{web_site}}       
                            {{facebook}}          
                            {{instagram}}         
                            {{twitter}}          
                            {{tax_number}}       
                            {{lat}}          
                            {{lng}}"
    ],
    "list_banner_image" => [
        "type" => "anomaly.field_type.file",
        "config" => [
            "folders" => ['images'],
            "mode" => "upload",
        ]
    ],
    "list_banner_url" => [
        "type" => "anomaly.field_type.url",
        "config" => [
            "default_value" => '#',
        ]
    ],
    'social_enabled' => [
        'type' => 'anomaly.field_type.boolean',
        'config' => [
            'default_value' => true,
        ],
    ],
    "show_product_nav" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => true,
        ]
    ],
    "show_cat_filter" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => true,
        ]
    ],
    "show_date_filter" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => true,
        ]
    ],
    "store_list_redirection" => [
        "type"   => "anomaly.field_type.select",
        "config" => [
            "options"       => [
                'list' => 'visiosoft.module.store::setting.list_store_products',
                'profile' => 'visiosoft.module.store::setting.store_profile',
            ],
            "default_value" => 'list',
            "mode"          => "dropdown",
        ]
    ],
    "add_official_company_name_field" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => false,
        ]
    ],
    "require_tax_on_registration" => [
        "type"   => "anomaly.field_type.boolean",
        "config" => [
            "mode" => "checkbox",
            "default_value" => false,
        ]
    ],
];
