<?php namespace Visiosoft\StoreModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class StoreModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-puzzle-piece';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'store' => [
            'buttons' => [
                'new_store',
                'export' => [
                    'href' => '/admin/store/export'
                ],
            ],
        ],
        'prices' => [
            'buttons' => [
                'new_price',
            ],
        ],
        'user' => [
            'buttons' => [
                'new_user',
                'export' => [
                    'href' => '/admin/store/user/export'
                ],
            ],
        ],
    ];

}
