<?php namespace Visiosoft\StoreModule\Store\StoreRegister;

use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\ProfileModule\Rules\ReCaptchaRule;

class StoreRegisterFormFields
{
    public function handle(StoreRegisterFormBuilder $builder)
    {
        $captchaSiteKey = setting_value('visiosoft.module.profile::google_captcha_site_key');
        $captchaSecretKey = setting_value('visiosoft.module.profile::google_captcha_secret_key');

        $register = [];
        if ($captchaSiteKey && $captchaSecretKey) {
            $register = [
                'recaptcha_token' => [
                    'required' => true,
                    'type' => 'anomaly.field_type.text',
                    'config' => [
                        "max" => 0,
                    ],
                    'rules' => [
                        'valid_recaptcha'
                    ],
                    'validators' => [
                        'valid_recaptcha' => [
                            'message' => false,
                            'handler' => ReCaptchaRule::class
                        ]
                    ]
                ],
            ];
        }

        if (setting_value('visiosoft.module.profile::show_checkbox_terms_on_register')) {
            $register = array_merge($register, [
                "approve_billing" => [
                    "type" => "anomaly.field_type.boolean",
                    "config" => [
                        "default_value" => false,
                        "mode" => "checkbox",
                        "label" => 'visiosoft.module.store::field.approve_billing_label',
                    ]
                ],
                "accept_terms" => [
                    "type" => "anomaly.field_type.boolean",
                    "config" => [
                        "default_value" => false,
                        "mode" => "checkbox",
                        "label" => 'visiosoft.module.profile::field.accept_terms_label',
                    ]
                ],
                "accept_protection_law" => [
                    "type" => "anomaly.field_type.boolean",
                    "config" => [
                        "default_value" => false,
                        "mode" => "checkbox",
                        "label" => 'visiosoft.module.profile::field.accept_protection_law_label',
                    ]
                ],
                "accept_privacy_terms" => [
                    "type" => "anomaly.field_type.boolean",
                    "config" => [
                        "default_value" => false,
                        "mode" => "checkbox",
                        "label" => 'visiosoft.module.profile::field.accept_privacy_terms_label',
                    ]
                ],
                "receive_sms_emails" => [
                    "type" => "anomaly.field_type.boolean",
                    "config" => [
                        "default_value" => false,
                        "mode" => "checkbox",
                        "label" => 'visiosoft.module.profile::field.receive_sms_emails_label',
                    ]
                ],
            ]);
        }

        $builder->setFields(
            array_merge(
                $register,
                [
                    "register_type" => [
                        "type" => "anomaly.field_type.select",
                        "config" => [
                            "options" => ['personal' => 'visiosoft.module.store::field.personal', 'corporate' => 'visiosoft.module.store::field.corporate'],
                            "mode" => "radio",
                        ],
                    ],
                    'username' => [
                        'required' => true,
                        'prefix' => 'store_',
                    ],
                    'first_name' => [
                        'instructions' => false,
                        'required' => true,
                        'prefix' => 'store_',
                    ],
                    'last_name' => [
                        'instructions' => false,
                        'required' => true,
                        'prefix' => 'store_',
                    ],
                    'phone' => [
                        'type' => 'anomaly.field_type.text',
                        'prefix' => 'store_',
                        'required' => true,
                        'rules' => [
                            'valid_register',
                        ],
                        'validators' => [
                            'valid_register' => [
                                'message' => false,
                                'handler' => \Visiosoft\StoreModule\Store\Validation\ValidateRegister::class,
                            ],
                        ],
                    ],
                    'email' => [
                        'prefix' => 'store_',
                        'instructions' => false,
                    ],
                    'password' => [
                        'prefix' => 'store_',
                        'instructions' => false,
                    ],
                    'category' => [
                        'type' => 'anomaly.field_type.select',
                        'config' => [
                            'handler' => 'Visiosoft\StoreModule\Store\Form\CategoriesOptions@handle'
                        ],
                        'required' => true,
                    ],
                    'country' => [
                        'type' => 'anomaly.field_type.relationship',
                        'config' => [
                            'related' => CountryModel::class
                        ],
                        'required' => true,
                    ],
                    'city' => [
                        'type' => 'anomaly.field_type.select',
                        'required' => true,
                    ],
                    'address' => [
                        'type' => 'anomaly.field_type.textarea',
                        'required' => true,
                    ],
                    'tax_number' => 'anomaly.field_type.integer',
                    'tax_administration' => 'anomaly.field_type.text',
                    'land_phone' => [
                        'type' => 'anomaly.field_type.text',
                        'required' => true,
                    ],
                ]
            )
        );
    }
}
