<?php namespace Visiosoft\StoreModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Chumper\Zipper\Zipper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Visiosoft\StoreModule\Seed\RegisterInstructionSeeder;

class StoreModuleSeeder extends Seeder
{

    /**
     * The disk repository.
     *
     * @var DiskRepositoryInterface
     */
    protected $disks;

    /**
     * The folder repository.
     *
     * @var FolderRepositoryInterface
     */
    protected $folders;

    /**
     * Create a new FolderSeeder instance.
     *
     * @param DiskRepositoryInterface $disks
     * @param FolderRepositoryInterface $folders
     */
    public function __construct(DiskRepositoryInterface $disks, FolderRepositoryInterface $folders)
    {
        parent::__construct();

        $this->disks = $disks;
        $this->folders = $folders;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        // Register Instruction Seeder
        $this->call(RegisterInstructionSeeder::class);

//        $disk = $this->disks->findBySlug('local');
//
//        $this->folders->create(
//
//            [
//                'id' => 12,
//                'en' => [
//                    'name' => 'STORE PAGE BANNER',
//                    'description' => 'A folder for store page images.',
//                ],
//                'tr' => [
//                    'name' => 'Mağaza Sayfası Banner',
//                    'description' => 'Mağaza banner resimleri.',
//                ],
//                'slug' => 'store_banner_folder',
//                'disk' => $disk,
//                'allowed_types' => [
//                    'png',
//                    'jpeg',
//                    'jpg',
//                ],
//            ]
//        );
//
//
//        $repository = "https://raw.githubusercontent.com/openclassify/Openclassify-Demo-Data/master/";
//        file_put_contents(__DIR__ . "/store.sql", fopen($repository . "store.sql", 'r'));
//        file_put_contents("store-files.zip", fopen($repository . "store-files.zip", 'r'));
//        $zipper = new Zipper();
//        $zipper->make('store-files.zip')->folder('store-files')->extractTo(base_path() . '/public/app/default/files-module/local/store_banner_folder/');
//        $zipper->close();
//
//        Model::unguard();
//        DB::unprepared(file_get_contents(__DIR__ . '/store.sql'));
//        Model::reguard();


    }

}