<?php namespace Visiosoft\StoreModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Http\Controller\AdvsController;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\Store\Form\StoreFormBuilder;
use Visiosoft\StoreModule\Store\StoreModel;

class StoreController extends PublicController
{
    private $model;
    private $advModel;
    private $storeUserRepository;
    private $advRepository;
    private $storeRepository;
    private $categoryRepository;
    private $categoryModel;
    private $advsController;
    private $userRepository;

    public function __construct(
        StoreModel $storeModel,
        AdvModel $advModel,
        \Visiosoft\StoreModule\User\Contract\UserRepositoryInterface $storeUserRepository,
        AdvRepositoryInterface $advRepository,
        StoreRepositoryInterface $storeRepository,
        CategoryRepositoryInterface $categoryRepository,
        CategoryModel $categoryModel,
        AdvsController $advsController,
        UserRepositoryInterface $userRepository
    )
    {
        parent::__construct();
        $this->model = $storeModel;
        $this->advModel = $advModel;
        $this->storeUserRepository = $storeUserRepository;
        $this->advRepository = $advRepository;
        $this->storeRepository = $storeRepository;
        $this->categoryRepository = $categoryRepository;
        $this->categoryModel = $categoryModel;
        $this->advsController = $advsController;
        $this->userRepository = $userRepository;
    }

    public function index($slug, Request $request)
    {
        $slug = str_slug($slug, '_');
        $store = $this->storeRepository->findBy('slug', $slug);
        if ($store) {
            $storeUsers = $this->storeRepository->getStoreUsers($store);
            $users = $storeUsers;

            if (isset($request['userId']) && !empty($request['userId'])) {
                $isStoreUser = $this->storeRepository
                    ->newQuery()
                    ->where('store_store.id', $store->id)
                    ->where('user_id', $request['userId'])
                    ->first();
                if (!$isStoreUser) {
                    $isStoreUser = $this->storeUserRepository
                        ->newQuery()
                        ->where('store_id', $store->id)
                        ->where('user_id', $request['userId'])
                        ->first();
                }
                if ($isStoreUser) {
                    $user = $this->userRepository->newQuery()->where('id', $request['userId'])->get();
                    if (count($user) === 1) {
                        $users = $user;
                    }
                }
            }
            $usersIds = $users->pluck('id');

            $rawAds = $this->advRepository->getByUsersIDs($usersIds);
            if (!empty($request['cat'])) {
                $rawAds = $this->checkCatParam($request['cat'], $rawAds);
            }
            $ads = clone $rawAds;
            $ads = $ads->paginate(setting_value('streams::per_page'));

            $advs = $this->advRepository->addAttributes($ads);
            foreach ($advs as $index => $ad) {
                $advs[$index]->detail_url = $this->advModel->getAdvDetailLinkByModel($ad, 'list');
                $advs[$index] = $this->advModel->AddAdsDefaultCoverImage($ad);
            }

            $previousCat = null;
            for ($i = 1; $i <= 10; $i++) {
                $cats = $rawAds
                    ->groupBy('cat' . $i)
                    ->pluck('cat' . $i)
                    ->toArray();
                if (count($cats) === 1 && !is_null($cats[0])) {
                    $previousCat = $cats;
                    continue;
                }
                if (!is_null($previousCat)) {
                    $mainCats = $this->categoryModel->getMains($previousCat);
                    $currentCat = $this->categoryModel->getCat($previousCat);
                    $mainCats[] = [
                        'id' => $currentCat->id,
                        'val' => $currentCat->name,
                    ];
                    $subCats = array();
                    foreach ($cats as $cat) {
                        $subCats[] = $this->categoryRepository->find($cat);
                    }
                } else {
                    $rawCats = array();
                    foreach ($cats as $cat) {
                        $rawCats[] = $this->categoryRepository->find($cat);
                    }
                    $mainCats = array();
                    $subCats = array();
                    foreach ($rawCats as $rawCat) {
                        if ($rawCat) {
                            $mainCats[] = [
                                'id' => $rawCat->id,
                                'val' => $rawCat->name,
                                'parentCat' => true
                            ];
                        }
                    }
                }
                break;
            }

            $compact = compact('advs', 'mainCats', 'subCats', 'request', 'ownerId', 'store', 'storeUsers');

            return $this->view->make('visiosoft.module.store::ads-list/list', $compact);
        }
        abort(404);
    }

    public function checkCatParam($catParam, $userAds) {
        $cat = new CategoryModel();
        $cat_d = $cat->find($catParam);
        if ($cat_d->parent_category_id == null) {
            $catLevel = 1;
        } else {
            $catLevel = $cat->getCatLevel($catParam);
        }
        $catLevel = "cat" . $catLevel;
        return $userAds->where($catLevel, $catParam);
    }

    public function edit(Request $request, StoreFormBuilder $form, $slug, $id)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->storeRepository->find($id);
        if ($store and $store->user_id == Auth::id()) {
            if ($request->action == "save") {
                $form->skipField('user');
                if ($form->hasFormErrors()) {
                    return back();
                }
                $form->render($id);
                return redirect(route('store::view', [$store->slug]));
            }
            return $this->view->make('visiosoft.module.store::edit', compact('store'));
        }
        abort(403);
    }

    public function storeDetail($slug)
    {
        $store = $this->storeRepository->findBy('slug', $slug);
        if ($store) {
            $storeUsers = $this->storeRepository->getStoreUsers($store);
            return $this->view->make('visiosoft.module.store::detail', compact('store', 'storeUsers'));
        } else {
            return redirect('/');
        }
    }


    public function create(Request $request, StoreFormBuilder $form)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        if ($request->action == "save") {
            $error = $form->build()->validate()->getFormErrors()->getMessages();
            if (!empty($error)) {
                return back();
            }
            $form->render();
            return redirect(route('store::view', [$request->slug]));
        }
        $mainCats = $this->categoryRepository->mainCats();
        return $this->view->make('visiosoft.module.store::create', compact('mainCats'));
    }

    public function addUser(Request $request, UserRepositoryInterface $userRepository, $slug)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->storeRepository->findBy('slug', $slug);
        $users =  $this->storeUserRepository->getUsers($store->id);
        if ($store and $store->user_id == Auth::id()) {
            if ($request->action == "save") {
                $user = $request->user_email ?
                    $userRepository->findByEmail($request->user_email) :
                    $userRepository->findBy('gsm_phone', $request->user_phone);
                if($user != null) {
                    $findUser = $this->storeUserRepository->findUser($user->id, $store->id);
                    if($store->user_id != $user->id and count($findUser) == 0) {
                        $this->storeUserRepository->addUser($user->id, $store->id);
                        return redirect('s/'.$store->slug.'/add-user')->withSuccess([trans('visiosoft.module.store::message.user_added')]);
                    } else {
                        return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.already_defined_user')]);
                    }
                } else {
                    return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.user_not_found')]);
                }
            }
            return $this->view->make('visiosoft.module.store::add-user', compact('store', 'users'));
        }
        abort(403);
    }

    public function removeUser($slug, $userId)
    {
        if (!Auth::user()) {
            redirect('/login?redirect=' . url()->current())->send();
        }
        $store = $this->storeRepository->findBy('slug', $slug);
        if ($store and $store->user_id == Auth::id()) {
            $find_user = $this->storeUserRepository->findUser($userId, $store->id);
            if($store->user_id != $userId and count($find_user) != 0)
            {
                $this->storeUserRepository->removeUser($userId, $store->id);
                return redirect('s/'.$store->slug.'/add-user')->withSuccess([trans('visiosoft.module.store::message.user_deleted')]);
            } else {
                return $this->redirect->back()->with('error', [trans('visiosoft.module.store::message.user_not_found')]);
            }
        }
        abort(403);
    }

    public function listStores(Request $request)
    {
        $params = $request->toArray();

        $stores = $this->storeRepository->searchStores($params);

        $cats = $this->categoryRepository->mainCats();

        $compact = compact('stores', 'request', 'cats');

        Cookie::queue(Cookie::make('last_search', $request->getRequestUri(), 84000));

        return $this->view->make('visiosoft.module.store::list/list', $compact);
    }
}
