<?php namespace Visiosoft\StoreModule\Store\StoreRegister\Command;

use Anomaly\UsersModule\User\UserActivator;
use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\UsersModule\User\Contract\UserInterface;
use Visiosoft\StoreModule\Store\StoreRegister\StoreRegisterFormBuilder;

class HandleEmailRegistration
{

    /**
     * The form builder.
     *
     * @var StoreRegisterFormBuilder
     */
    protected $builder;

    /**
     * Create a new HandleEmailRegistration instance.
     *
     * @param StoreRegisterFormBuilder $builder
     */
    public function __construct(StoreRegisterFormBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param UserActivator $activator
     * @param MessageBag    $messages
     */
    public function handle(UserActivator $activator, MessageBag $messages)
    {
        /* @var UserInterface $user */
        $user = $this->builder->getFormEntry();

        $activator->send($user, $this->builder->getFormOption('activate_redirect', '/'));

        if (!is_null($message = $this->builder->getFormOption('confirm_message'))) {
            $messages->info($message);
        }
    }
}
