<?php namespace Visiosoft\StoreModule\User\Table;

use Anomaly\Streams\Platform\Entry\EntryModel;

class UserTableColumns
{
    public function handle(UserTableBuilder $builder)
    {
        $builder->setColumns([
            'store' => [
                'value' => function (EntryModel $entry) {
                    if ($store = $entry->getStore()) {
                        $url = route('visiosoft.module.store::admin.edit', ['id' => $store->getId()]);
                        return '<a href="' . $url . '">' . $store->getName() . '</a>';
                    }
                }
            ],
            'user' => [
                'value' => function (EntryModel $entry) {
                    $user = $entry->getUser();
                    if ($user) {
                        $url = '/admin/users/edit/' . $user->getId();
                        return '<a href="' . $url . '">' . $user->name() . '(' . $user->getId() . ')</a>';
                    } else {
                        return '<a href="#">' . trans('visiosoft.module.store::field.user_not_found') . '</a>';
                    }
                }
            ],
        ]);
    }
}
