<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleStoreAddUrlToThumbSliderStream extends Migration
{
	protected $delete = true;

	protected $stream = [
		'slug' => 'thumb_slider',
	];

	protected $fields = [
		'slider' => [
			"type"   => "anomaly.field_type.file",
			"config" => [
				"folders" => ['images'],
				"mode" => "upload",
			]
		],
		'url' => [
			'type' => 'anomaly.field_type.url'
		]
	];

	protected $assignments = [
		'slider',
		'url'
	];

	public function up()
	{
		if ($field = $this->fields()->findBySlugAndNamespace('sliders', 'store')) {
			$field->delete();
		}
	}

}
