<?php namespace Visiosoft\StoreModule\Store\Form;

use Visiosoft\StoreModule\Store\StoreModel;

class StoreFormSections
{
    public function handle(StoreFormBuilder $builder, StoreModel $store)
    {
        $fields = [
            'name',
            'user',
            'slug',
            'summary',
            'detailed_description',
            'land_phone',
            'address',
            'category',
            'country',
            'city',
            'email',
            'web_site',
            'gold_supplier',
            'facebook',
            'instagram',
            'twitter',
            'file',
            'store_banner',
            'iban_number',
            'status',
            'tax_number',
            'tax_administration',
        ];


        $assignments = $store->getAssignments();

        $otherFields = $assignments->notLocked()->fieldSlugs();

        $builder->setSections(
            [
                'user' => [
                    'tabs' => [
                        'store' => [
                            'title'  => 'visiosoft.module.store::tab.store',
                            'fields' => $fields,
                        ],
                        'other' => [
                            'title'  => 'visiosoft.module.store::tab.other',
                            'fields' => $otherFields,
                        ],
                    ],
                ],
            ]
        );
    }
}
