<?php namespace Visiosoft\StoreModule\Store\Validation;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Str;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class ValidateRegister
{
    public function handle(
        FormBuilder $builder,
        Str $str,
        StoreRepositoryInterface $storeRepository,
        UserRepositoryInterface $userRepository
    )
    {
        // Validate Phone Number
        if (!is_numeric($builder->getPostValue('phone'))) {
            $builder->addFormError('phone', trans('visiosoft.module.profile::message.error_valid_phone'));
            return false;
        } elseif (!is_null($userRepository->newQuery()->where('gsm_phone', $builder->getPostValue('phone'))->first())) {
            $builder->addFormError('phone', trans('visiosoft.module.profile::message.registered_phone'));
            return false;
        }

        // Validate Store Slug
        $storeExist = $storeRepository
            ->findBy('slug', $str->slug($builder->getPostValue('first_name') . " " . $builder->getPostValue('last_name'), '_'));
        if ($storeExist) {
            $builder->addFormError('first_name', trans('visiosoft.module.store::message.registered_store'));
            return false;
        }

        return true;
    }
}
