<?php namespace Visiosoft\StoreModule\Http\Controller\Admin;

use Maatwebsite\Excel\Facades\Excel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;
use Visiosoft\StoreModule\Store\StoreExports;
use Visiosoft\StoreModule\User\Form\UserFormBuilder;
use Visiosoft\StoreModule\User\Table\UserTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class UserController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param UserTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(UserTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param UserFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(UserFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param UserFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(UserFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function export(StoreRepositoryInterface $store)
    {
        return Excel::download(new StoreExports, 'usersStore.xlsx');
    }
}
