<?php namespace Visiosoft\StoreModule\Store\Table;

use Anomaly\Streams\Platform\Entry\EntryModel;
use Visiosoft\StoreModule\Category\Contract\CategoryRepositoryInterface;

class StoreTableColumns
{
    public function handle(StoreTableBuilder $builder)
    {
        $builder->setColumns([
            'name' => [
                'sort_column' => 'slug',
                'wrapper' => '
                    <strong>{value.name}</strong><span class="text-muted">(#{value.id})</span>
                    <br>
                    <small class="text-muted">{value.owner}</small>',
                'value' => [
                    'id' => 'entry.id',
                    'name' => 'entry.name',
                    'owner' => 'entry.user.name'
                ],
            ],
            'category' => [
                'value' => function (EntryModel $entry,CategoryRepositoryInterface $repository) {
                    $category = $repository->newQuery()->find($entry->category);

                    return ($category) ? $category->name : '-';
                }
            ],
            'type' => [
                'value' => function (EntryModel $entry) {
                    return ($entry->is_store) ? trans('visiosoft.module.store::button.store') : trans('visiosoft.module.store::button.company');
                }
            ],
            'phone' => [
                'sortable' => false,
                'wrapper' => '<span>{value.land_phone}</span><br><span>{value.gsm_phone}</span>',
                'value' => [
                    'land_phone' => 'entry.land_phone',
                    'gsm_phone' => 'entry.gsm_phone',
                ],
            ],
            'status' => [
                'wrapper' => function (EntryModel $entry) {
                    $class = ($entry->status == "approved") ? 'fa-check' : 'fa-spinner';
                    return "<i class='fa " . $class . "'></i>";
                },
            ],
        ]);
    }
}
