<?php namespace Visiosoft\StoreModule;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Illuminate\Support\Str;
use Visiosoft\StoreModule\Store\Command\GetStoresByCoordinates;
use Visiosoft\StoreModule\Store\Command\GetStoreByUserId;

class StoreModulePlugin extends Plugin
{
    public function getFunctions()
    {
        return [
            new \Twig_SimpleFunction(
                'slug',
                function ($entry) {
                    return Str::slug($entry);
                }
            ),
            new \Twig_SimpleFunction(
                'get_stores_by_coordinates',
                function ($lat, $lng, $distance = 50) {
                    return $this->dispatch(new GetStoresByCoordinates($lat, $lng, $distance));
                }
            ),
            new \Twig_SimpleFunction(
                'getStoreByUserId',
                function ($id) {
                    return $this->dispatch(new GetStoreByUserId($id));
                }
            ),
        ];
    }
}
