getCountries();

const countryInit = () => {
    const selectedCountry = typeof country !== 'undefined' ? country : default_country
    if (parseInt(selectedCountry)) {
        $('select[name="country"]').val(selectedCountry);
        getCities(selectedCountry);
    }
}

const cityInit = () => {
    const selectedCity = typeof city !== 'undefined' ? city : default_city
    if (parseInt(selectedCity)) {
        $('select[name="city"]').val(selectedCity);
        getDistricts(parseInt(selectedCity)).then(function () {
            if (typeof district !== 'undefined') {
                $('select[name="district"]').val(district);
            }
        });

    }
}

function getCities(country) {
    const selectCityInput = $('select[name=city]')
    selectCityInput.prop('disabled', true)
    return crudAjax(`id=${country}`, '/ajax/getCities', 'POST', function (callback) {
        cities = callback;
        $('select[name="city"]').html("<option value=''>" + pick_option + "</option>");
        $.each(cities, function (index, value) {
            $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
        selectCityInput.prop('disabled', false)
        cityInit();
    })
}

function getDistricts(city) {
    const selectDistrictInput = $('select[name=district]');
    selectDistrictInput.prop('disabled', true)
    return crudAjax(`id=${city}`, '/ajax/getDistricts', 'POST', function (callback) {
        districts = callback;
        $('select[name="district"]').html("<option value=''>" + pick_option + "</option>");
        $.each(districts, function (index, value) {
            $('select[name="district"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
        selectDistrictInput.prop('disabled', false)
    })
}

$(document).on('change', 'select[name="country"]', function () {
    getCities($(this).val());
});

$(document).on('change', 'select[name="city"]', function () {
    getDistricts($(this).val());
});

function getCountries() {
    crudAjax('', '/ajax/getCountry', 'GET', function (callback) {
        $('select[name="country"]').html("<option>" + pick_option + "</option>");
        $.each(callback, function (index, value) {
            $('select[name="country"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
        countryInit();
    }, true)
}
