<?php namespace Visiosoft\StoreModule\Store\Validation;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;

class ValidateRegister
{
    public function handle(
        FormBuilder $builder,
        UserRepositoryInterface $userRepository
    )
    {
        // Validate Phone Number
        if (!is_numeric($builder->getPostValue('store_phone'))) {
            $builder->addFormError(
                'store_phone',
                trans('visiosoft.module.profile::message.error_valid_phone')
            );

            return false;
        } elseif (!is_null($userRepository->newQuery()->where('gsm_phone', $builder->getPostValue('store_phone'))->first())) {
            $builder->addFormError(
                'store_phone',
                trans('visiosoft.module.profile::message.registered_phone')
            );

            return false;
        }

        return true;
    }
}
