<?php namespace Visiosoft\StoreModule\Store\Form;

use Visiosoft\StoreModule\Store\StoreModel;

class StoreFormSections
{
    public function handle(StoreFormBuilder $builder, StoreModel $store)
    {
        $fields = [
            'name',
            'user',
            'slug',
            'summary',
            'detailed_description',
            'land_phone',
            'gsm_phone',
            'address',
            'category',
            'country',
            'city',
            'district',
            'email',
            'web_site',
            'gold_supplier',
            'verified',
            'facebook',
            'instagram',
            'twitter',
            'file',
            'store_banner',
            'iban_number',
            'status',
            'tax_number',
            'tax_administration'
        ];

        $meta_fields = [
            'meta_title',
            'meta_description',
            'meta_keywords',
        ];

        $assignments = $store->getAssignments();
        $otherFields = $assignments->notLocked()->fieldSlugs();

        $builder->setSections([
            'user' => [
                'tabs' => function () use ($fields, $meta_fields, $otherFields) {
                    $sections = [
                        'store' => [
                            'title' => 'visiosoft.module.store::tab.store',
                            'fields' => $fields,
                        ],
                        'meta' => [
                            'title' => 'visiosoft.module.store::tab.meta',
                            'fields' => $meta_fields,
                        ],
                    ];

                    if (count($otherFields)) {
                        $sections = array_merge($sections, [
                            'other' => [
                                'title' => 'visiosoft.module.store::tab.other',
                                'fields' => $otherFields,
                            ],
                        ]);
                    }

                    return $sections;
                },
            ],
        ]);
    }
}
