<?php namespace Visiosoft\StoreModule\Http\Controller\Admin;

use Visiosoft\StoreModule\Doping\Contract\DopingRepositoryInterface;
use Visiosoft\StoreModule\Doping\Form\DopingFormBuilder;
use Visiosoft\StoreModule\Doping\Table\DopingTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class DopingsController extends AdminController
{
    public function index(DopingTableBuilder $table)
    {
        return $table->render();
    }

    public function create(DopingFormBuilder $form)
    {
        return $form->render();
    }

    public function edit(DopingFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    public function approve(DopingRepositoryInterface $dopingRepository, $id)
    {
        $storeDoping = $dopingRepository->find($id);

        if (!$storeDoping) {
            abort(404);
        }

        if ($storeDoping->finish_at) {
            $this->messages->error(trans('visiosoft.module.store::message.doping_already_approved'));
            return redirect()->back();
        }

        $storeDoping->approve($storeDoping->doping_type->duration);

        $this->messages->success(trans('visiosoft.module.store::message.doping_approved'));

        return redirect()->back();
    }
}
